/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#pragma once
#include "resource.h"
#include "CyPhyML.h"
#include "afxcmn.h"

// CDSERootSelDialog dialog

class CDSERootSelDialog : public CDialog
{
	DECLARE_DYNAMIC(CDSERootSelDialog)

public:
	CDSERootSelDialog(CWnd* pParent = NULL);   // standard constructor
	CDSERootSelDialog(CyPhyML::RootFolder &rf, CWnd* pParent = NULL);   
	virtual ~CDSERootSelDialog();
	Udm::Object GetSelectedDSERoot();
	virtual BOOL OnInitDialog();
// Dialog Data
	enum { IDD = IDD_DSEROOT_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
public:	
	afx_msg void OnTvnSelchangedDstree(NMHDR *pNMHDR, LRESULT *pResult);
private:
	CTreeCtrl m_dstree;
	map<HTREEITEM, Udm::Object> dseTreeMap;
	Udm::Object dseroot_sel;
	CyPhyML::RootFolder cyphy_rf;
protected:
	void FillDSETree(CyPhyML::DesignContainer &cyphy_con, HTREEITEM parent); 
	void FillDSETree(CyPhyML::DesignSpace &cyphy_ds, HTREEITEM parent);
};
