/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// MophyMatrixFileDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MophyMatrixFileDlg.h"
#include "afxdialogex.h"


// CMophyMatrixFileDlg dialog

IMPLEMENT_DYNAMIC(CMophyMatrixFileDlg, CDialog)

CMophyMatrixFileDlg::CMophyMatrixFileDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMophyMatrixFileDlg::IDD, pParent)
{

}

CMophyMatrixFileDlg::~CMophyMatrixFileDlg()
{
}

void CMophyMatrixFileDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CMophyMatrixFileDlg, CDialog)
	ON_BN_CLICKED(IDC_OUTPUTBTN, &CMophyMatrixFileDlg::OnBnClickedOutputbtn)
	ON_EN_CHANGE(IDC_FILEPATHEDIT, &CMophyMatrixFileDlg::OnEnChangeFilepathedit)
END_MESSAGE_MAP()


// CMophyMatrixFileDlg message handlers


void CMophyMatrixFileDlg::OnBnClickedOutputbtn()
{
	// TODO: Add your control notification handler code here
	CString m_strFile = m_filepath;
	CFileDialog fileDlg( TRUE, NULL, NULL, OFN_FILEMUSTEXIST, "Excel Files (*.csv)|*.csv|All Files (*.*)|*.*||", this);
	// Call DoModal
	if ( fileDlg.DoModal() == IDOK)
	{
		m_filepath = fileDlg.GetPathName(); // This is your selected file name with path
		GetDlgItem(IDC_FILEPATHEDIT)->SetWindowText(m_filepath);
	}
}


void CMophyMatrixFileDlg::OnEnChangeFilepathedit()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here
	GetDlgItem(IDC_FILEPATHEDIT)->GetWindowText(m_filepath);
}
