/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// StatusDialog.cpp : implementation file
//

#include "stdafx.h"
#include "StatusDialog.h"


// CStatusDialog dialog

IMPLEMENT_DYNAMIC(CStatusDialog, CDialog)

CStatusDialog::CStatusDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CStatusDialog::IDD, pParent),
	  processPos(0)
{
	m_maxPrg  = 100;
	m_cancel = false;
}

CStatusDialog::~CStatusDialog()
{
}

void CStatusDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PROGRESS1, m_prgBar);
	DDX_Control(pDX, IDC_EDIT1, m_status);
}


BEGIN_MESSAGE_MAP(CStatusDialog, CDialog)
//	ON_BN_CLICKED(IDC_CANCELBTN, &CStatusDialog::OnBnClickedCancelbtn)
END_MESSAGE_MAP()

BOOL CStatusDialog::OnInitDialog()
{
	CDialog::OnInitDialog();
	//splash

	// TODO:  Add extra initialization here

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CStatusDialog::SetProgress(const CString &status)
{
	if(processPos > m_maxPrg) processPos = 0;
	m_prgBar.SetRange( 0, m_maxPrg);
	m_prgBar.SetPos(processPos);

	processPos += 10;

	m_status.SetWindowText(status);

	this->UpdateData();
	this->UpdateWindow();
	this->RedrawWindow();
	this->ShowWindow(SW_SHOW);
}

void CStatusDialog::OnFinished()
{
	m_prgBar.SetRange( 0, m_maxPrg);
	while(processPos < m_maxPrg)
	{
		Sleep(20);
		m_prgBar.StepIt();
		processPos += 5;
	}
	CDialog::OnCancel();
}

void CStatusDialog::SetRange(int range)
{
	if(range > m_maxPrg)
		m_maxPrg = range;
};

CStatusDialog * GetStatusDlg(CStatusDialog * set)
{
	static CStatusDialog * csdlg;
	
	if (set) csdlg = set;
	ASSERT(csdlg != NULL);
	return csdlg;
};

void CStatusDialog::OnCancel()
{
	// TODO: Add your control notification handler code here
	m_cancel = true;
	CDialog::OnCancel();
}

void CStatusDialog::PostNcDestroy() 
{
	CDialog::PostNcDestroy();
	delete this; 
}
