/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Threading;
using Microsoft.Win32;
using System.IO;

namespace JobManager
{
    public class SSHConnection : IDisposable
    {
        Process proc0;
        public string SSHHost { get { return Properties.Settings.Default.SSHHost; } }
        public string SSHUser { get { return Properties.Settings.Default.SSHUser; } }
        public string SSHPort { get { return Properties.Settings.Default.SSHPort; } }

        public SSHConnection()
        {
            RegistryKey metaKey = RegistryKey.OpenBaseKey(RegistryHive.CurrentUser, RegistryView.Registry32)
                .CreateSubKey("Software\\SimonTatham\\PuTTY\\SshHostKeys");
            metaKey.SetValue("rsa2@22:fangbeta.isis.vanderbilt.edu",
                "0x10001,0xb74d5fe7c70c45a8c08b7263e1c807e84201be3a3dc0c288ea59a860e7ce47dd256087b7c82e35d144bc00e715bcced6084549da790318a027d6a4bb9e0262327e89a38fd49fdfe66473b605c40a6f4d70daff56d46c23f03264590e0ab1a012af9effd1c89cf30dd75a852c2f6dbb5c6d0dfae8ae4470efaec1278aa79a6ffe73d49ac55e2dffe9eac3cf19924a2aecb289b014e7ca1df01392116dbce0f944dc862dc4d80b3d20f7d64cec54527a14de9f7d51f63bd7e370a969a1cb6a3993c2d2edf349bec66aa34021fa341c5f853e2e8969d1a4264f0d04a5c31e6f2856fd61ef2967e76920a8c773f00b77f2e6988d0d47ba9de304f6ac28f0609444e7");
        }

        public static string MetaPathValue
        {
            get
            {
                const string keyName = "Software\\META";

                RegistryKey metaKey = RegistryKey.OpenBaseKey(RegistryHive.LocalMachine, RegistryView.Registry32)
                    .OpenSubKey(keyName, false);

                string metaPath = "C:\\Program Files (x86)\\META";
                if (metaKey != null)
                {
                    metaPath = (string)metaKey.GetValue("META_PATH", metaPath);
                }

                return metaPath;
            }
        }


        public void Connect()
        {
            Disconnect();

            if (string.IsNullOrWhiteSpace(SSHHost) == false)
            {
                proc0 = new Process();
                ProcessStartInfo info = proc0.StartInfo = new ProcessStartInfo();
                info.FileName = Path.Combine(MetaPathValue, "bin", "GMEplink.exe");
                //info.FileName = @"C:\Users\ksmyth\Downloads\plink.exe";
            // TODO: "-i keyfile" so user need not run pagent
                info.Arguments = "-L " + SSHPort + ":localhost:8080 -N " + SSHUser + "@" + SSHHost;
                //info.WindowStyle = ProcessWindowStyle.Normal;
                //info.CreateNoWindow = false;
                info.RedirectStandardOutput = true;
                info.RedirectStandardError = true;
                info.RedirectStandardInput = true;
                info.UseShellExecute = false;

                StringBuilder stderr = new StringBuilder();
                StringBuilder stdout = new StringBuilder();
                AutoResetEvent dataReceived = new AutoResetEvent(false);

                proc0.OutputDataReceived += ((sender2, e2) =>
                {
                    dataReceived.Set();
                    stdout.Append(e2.Data);
                });
                proc0.ErrorDataReceived += ((sender2, e2) =>
                {
                    dataReceived.Set();
                    stderr.Append(e2.Data);
                });
                proc0.Start();
                if (info.RedirectStandardOutput)
                {
                    proc0.BeginOutputReadLine();
                }
                if (info.RedirectStandardError)
                {
                    proc0.BeginErrorReadLine();
                }
                bool recvd = dataReceived.WaitOne(TimeSpan.FromSeconds(10));
                if (recvd == false)
                {
                    throw new TimeoutException("SSH Connection timed out");
                }
            }
        }
        public void Disconnect()
        {
            if (proc0 != null)
            {
                try
                {
                    proc0.Kill();
                }
                catch (InvalidOperationException e)
                {
                    if (!e.ToString().Contains("has exit"))
                        throw;
                }
                proc0.Close();
                proc0 = null;
            }
        }

        public void Dispose()
        {
            Disconnect();
        }
    }
}
