/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// UdmApp.cpp: implementation of the CUdmApp class.
// This file was automatically generated as UdmApp.cpp
// by UDM Interpreter Wizard on Thursday, March 27, 2008 10:37:31
#include "stdafx.h"
#include "UdmApp.h"
#include "UdmConfig.h"
#include "Uml.h"
#include "CyPhyML.h"
#include "UdmConsole.h"
#include "time.h"
#include "UdmUtil.h"
#include "MophyMatrixFileDlg.h"

#include<iostream>
#include<fstream>

using namespace CyPhyML;

CString CUdmApp::mgaPath = "";

std::string getFileNameNoExt(const std::string &fullpath)
{
	std::string ret = fullpath;
	size_t pos = ret.rfind("\\");
	if(pos!=string::npos)
		ret = ret.substr(pos+1);
	pos = ret.find(".");
	if(pos!=string::npos)
		ret = ret.substr(0, pos);
	return ret;
}

std::string appendObjLink(const Udm::Object &obj)
{
	if (!obj)
		return "null";
	return ("<A HREF=\"mga:"+ UdmGme::UdmId2GmeId(obj) + "\">" + UdmUtil::ExtractName(obj) + "</A>");
}
/*********************************************************************************/
/* Initialization function. The framework calls it before preparing the backend. */
/* Initialize here the settings in the config global object.					  */
/* Return 0 if successful.														  */
/*********************************************************************************/
int CUdmApp::Initialize()
{

	// TODO: Your initialization code comes here...
	return 0;
}



/* 
Remarks to CUdmApp::UdmMain(...):
0.	The p_backend points to an already open backend, and the framework 
	closes it automatically. DO NOT OPEN OR CLOSE IT!
	To commit changes use p_backend->CommitEditSequence().
	To abort changes use p_backend->AbortEditSequence().
	To save changes to a different file use p_backend->SaveAs() or p_backend->CloseAs().

1.	Focus is the currently open model.

2.	The possible values for param (from GME DecoratorLib.h component_startmode_enum):
	GME_MAIN_START			=   0,
	GME_BROWSER_START		=   1,
	GME_CONTEXT_START		=   2,
	GME_EMBEDDED_START		=   3,
	GME_MENU_START			=  16,
	GME_BGCONTEXT_START		=  18,
	GME_ICON_START			=  32,
	METAMODEL_CHECK_SYNTAX	= 101

 3. The framework catches all the exceptions and reports the error in a message box,
	clean up and close the transactions aborting the changes. You can override this 
	behavior by catching udm_exception. Use udm_exception::what() to form an error 
	message.
*/

/***********************************************/
/* Main entry point for Udm-based Interpreter  */
/***********************************************/
void CUdmApp::UdmMain(
					 Udm::DataNetwork* p_backend,		// Backend pointer(already open!)
					 Udm::Object focusObject,			// Focus object
					 set<Udm::Object> selectedObjects,	// Selected objects
					 long param)						// Parameters
{	
	char currdate[128];
	char currtime[128];
	_strdate( currdate);
	_strtime( currtime );
	std::string cd(currdate);
	std::string ct(currtime);

	try{
		CyPhyML::RootFolder cyphy_rf = CyPhyML::RootFolder::Cast(p_backend->GetRootObject());
		CyPhyML::Configurations cfgs;
		if(focusObject!=Udm::null && (Uml::IsDerivedFrom(focusObject.type(), CyPhyML::Configurations::meta)))
		{	
			cfgs = CyPhyML::Configurations::Cast(focusObject);
		}

		if(cfgs==Udm::null){
			AfxMessageBox("Please open a Configurations model to invoke this interpreter.");
			return;
		}

		set<int> cfg_ids;
		CMophyMatrixFileDlg dlg;
		if(dlg.DoModal()==IDOK)
		{
			ifstream mmFile;
			mmFile.open(dlg.m_filepath);
			char id[100];
			if (mmFile.is_open()) 
			{
				 while (!mmFile.eof()) 
				 {
					mmFile >> id;
					cfg_ids.insert(atoi(id));
				 }
			}
			mmFile.close();
		}

		set<CyPhyML::CWC> cwcs = cfgs.CWC_kind_children();
		for(set<CyPhyML::CWC>::iterator i=cwcs.begin();i!=cwcs.end();++i)
		{
			CyPhyML::CWC cwc = *i;
			if(cfg_ids.find(cwc.ID())==cfg_ids.end())
			{
				cwc.DeleteObject();
			}
		}
	}
	catch(udm_exception &exc)
	{
		AfxMessageBox(exc.what());
		throw exc;
	}
	catch(...)
	{
		throw;
	}
}