from numpy import *

from openmdao.lib.drivers.api import DOEdriver
from openmdao.lib.casehandlers.api import ListCaseRecorder
#from listgen import ListGen

from enthought.traits.api import HasTraits
#from openmdao.lib.datatypes.api import Int, List
from openmdao.main.interfaces import implements, IDOEgenerator

class ListGen(HasTraits):
    """
    DOEgenerator that returns rows in a list of inputs.
    Plugs into the DOEgenerator socket on a DOEdriver.
    """
    
    implements(IDOEgenerator)
    
#    inputs = List([], iotype='in', desc='List of parameters.')

    def __init__(self, *args, **kwargs):
        super(ListGen, self).__init__(*args, **kwargs)

    def __iter__(self):
        """ Return an iterator over our sets of input values. """
        return self._next_row()

    def SetInputs(self, inputs):
        self.inputs = inputs

    def _next_row(self):
        nsims = len(self.inputs)
        for i, row in enumerate(self.inputs):
            print 'Running simulation',i+1,'of',nsims,'with inputs',row
            yield row

def run_model(driver,input):
    driver.set_parameters(input)
    driver.run_iteration()
    output = driver.eval_objectives()
    return array(output)

def run_list(driver,inputs):
    driver.DOEgenerator.SetInputs(inputs)
    driver.recorders = [ListCaseRecorder(),]
    #driver.sequential = False
    super(driver.__class__, driver).execute()

    outputs = []
    for c in driver.recorders[0].get_iterator():
        outputs.append(c.values('out'))

    return asarray(outputs)

    
    
    

    
         
        
        
