class ModelicaError(Exception):
    """
    Base class for all exceptions in py_modelica
    """

    sp_msg = 'Exception not raised by subprocess call.'
    def __init__(self, message, sp_msg=''):
        self.message = message
        if sp_msg:
            self.sp_msg = sp_msg

class ModelicaInstantiationError(ModelicaError):
    """
    Raised whenever the instantiation of the simulation tool fails
    """

    def __init__(self, message, sp_msg=''):
        ModelicaError.__init__(self, message, sp_msg)

class ModelicaCompilationError(ModelicaError):
    """
    Raised whenever the compilation of the Modelica code fails.
    """

    def __init__(self, message, sp_msg=''):
        ModelicaError.__init__(self, message, sp_msg)

class ModelicaSimulationError(ModelicaError):
    """
    Raised whenever the simulation of the compiled Modelica code fails.
    """

    def __init__(self, message, sp_msg=''):
        ModelicaError.__init__(self, message, sp_msg)