import os
from abc import ABCMeta
from py_modelica.modelica_simulation_tools.tool_base import ToolBase
from py_modelica.exception_classes import ModelicaInstantiationError

class _DymolaBase(ToolBase):
    __metaclass__ = ABCMeta
    MAX_DYMOLA_STEP_TIME = 3000 # * 0.1 = max time waiting for status to get updated with new time

    def __init__(self,
                 model_config,
                 dymola_home=r"C:\Program Files (x86)\Dymola 2013\bin64"):
        """
        Common constructor for Dymola and DymolaDemo

        """

        if os.name == 'nt':
            try:
                dymola_reg, version_nbr  = self._query_registry('Dymola 2013')
                self.tool_version_nbr = version_nbr
            except Exception:
                dymola_reg = ""

            dymola_default = r"C:\Program Files (x86)\Dymola 2013"

            # Check if given path exists and contains dymola.exe
            if os.path.exists(os.path.join(dymola_home, "dymola.exe")):
                self.tool_path = dymola_home

            # If not found, look if dymola installed at its default location
            elif os.path.exists(os.path.join(dymola_default, "bin64", "dymola.exe")):
                self.tool_path = os.path.join(dymola_default, "bin64")
            elif os.path.exists(os.path.join(dymola_default, "bin", "dymola.exe")):
                self.tool_path = os.path.join(dymola_default, "bin")

            # If not found, look in the path returned from registry
            elif dymola_reg:
                if os.path.exists(os.path.join(dymola_reg, "bin64", "dymola.exe")):
                    self.tool_path = os.path.join(dymola_reg, "bin64")
                elif os.path.exists(os.path.join(dymola_reg, "bin", "dymola.exe")):
                    self.tool_path = os.path.join(dymola_reg, "bin")

            # If not found in any of these cases raise an exception
            else:
                msg = "Dymola path not found at any of: {0} ; {1} ; {2}".format(
                        dymola_home, dymola_default, dymola_reg)
                raise ModelicaInstantiationError(msg)

            try:
                import _winreg as wr
                key = wr.OpenKey(wr.HKEY_LOCAL_MACHINE, r'software\meta', 0, wr.KEY_READ)
                try:
                    self.MAX_DYMOLA_STEP_TIME = wr.QueryValueEx(key, 'MAX_DYMOLA_STEP_TIME')[0]
                    print 'Found MAX_DYMOLA_STEP_TIME in registry, value was {0}'\
                        .format(self.MAX_DYMOLA_STEP_TIME)
                except WindowsError:
                    print 'MAX_DYMOLA_STEP_TIME not set in registry, using default (5min).'
            except WindowsError:
                print 'META-Tools not installed, using default MAX_DYMOLA_STEP_TIME (5min).'





        self._initialize(model_config)

    def _query_registry(self, display_name='Dymola 2013'):
        """
        Queries the registry for the installation path of Dymola.

        """
        import _winreg

        base_key = r'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall'

        uninstall_key = _winreg.OpenKey(_winreg.HKEY_LOCAL_MACHINE, base_key, 0,
                                        _winreg.KEY_ALL_ACCESS | _winreg.KEY_WOW64_32KEY)

        number_of_keys =  _winreg.QueryInfoKey(uninstall_key)[0] # 0 means number of sub_keys

        product_key = None
        for sub_key_id in range(0, number_of_keys):
            sub_key_name = _winreg.EnumKey(uninstall_key, sub_key_id)
            sub_key = _winreg.OpenKey(uninstall_key, sub_key_name)
            number_of_values = _winreg.QueryInfoKey(sub_key)[1]
            for value_id in range(0, number_of_values):
                value_tuple = _winreg.EnumValue(sub_key, value_id)
                value_name = value_tuple[0]
                value = value_tuple[1]
                if value_name == 'DisplayName' and value == display_name:
                    product_key = sub_key

        if not product_key:
            return "",""

        install_location = ""
        display_version = ""
        number_of_values = _winreg.QueryInfoKey(product_key)[1]
        for value_id in range(0, number_of_values):
            value_tuple = _winreg.EnumValue(product_key, value_id)
            value_name = value_tuple[0]
            value = value_tuple[1]
            if value_name == "InstallLocation":
                install_location = value
            elif value_name == "DisplayVersion":
                display_version = value

        return install_location, display_version


