/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef CYPHYUTIL_CPP
#define CYPHYUTIL_CPP

#include "UmlExt.h"
#include "CyPhyUtil.h"

namespace CyPhyUtil
{
	using namespace CyPhyML;
	ComponentPortPair getConnectionEnds(const Uml::Class &type, const Udm::Object &conn)
	{
		if(Uml::IsDerivedFrom(type, CyPhyML::Composition::meta))
		{
			return getCompositionEnds(type, conn);
		}
		else if(Uml::IsDerivedFrom(type, CyPhyML::ValueFlow::meta))
		{
			ValueFlow vf = ValueFlow::Cast(conn);
			ComponentPortPair portPair;
			portPair.srcRoleName = "srcValueFlow";
			portPair.src.port = vf.srcValueFlow_end();
			portPair.src.port_ref_parent = vf.srcValueFlow_refport_parent();
			portPair.dstRoleName = "dstValueFlow";
			portPair.dst.port = vf.dstValueFlow_end();
			portPair.dst.port_ref_parent = vf.dstValueFlow_refport_parent();
			return portPair;
		}
		else if(Uml::IsDerivedFrom(type, CyPhyML::AssignJoinData::meta))
		{
			CyPhyML::AssignJoinData ajd = CyPhyML::AssignJoinData::Cast(conn);
			ComponentPortPair portPair;
			portPair.srcRoleName = "srcAssignJoinData";
			portPair.src.port = ajd.srcAssignJoinData_end();
			portPair.dstRoleName = "dstAssignJoinData";
			portPair.dst.port =ajd.dstAssignJoinData_end();
			portPair.dst.port_ref_parent = ajd.dstAssignJoinData_refport_parent();
			return portPair;
		}
		else
			throw udm_exception(std::string("Unknown connection type ") + static_cast<std::string>(type.name()));
	};

	ComponentPortPair getCompositionEnds(const Uml::Class &type, const Udm::Object &conn)
	{
		ComponentPortPair portPair;
		if (type == PowerFlow::meta)
		{
			PowerFlow assoc = PowerFlow::Cast(conn);
			portPair.srcRoleName = "srcPowerFlow";
			portPair.src.port = assoc.srcPowerFlow_end();
			portPair.src.port_ref_parent = assoc.srcPowerFlow_refport_parent();
			portPair.dstRoleName = "dstPowerFlow";
			portPair.dst.port = assoc.dstPowerFlow_end();
			portPair.dst.port_ref_parent = assoc.dstPowerFlow_refport_parent();
		} 
		else if (type == InformationFlow::meta)
		{
			InformationFlow assoc = InformationFlow::Cast(conn);
			portPair.srcRoleName = "srcInformationFlow";
			portPair.src.port = assoc.srcInformationFlow_end();
			portPair.src.port_ref_parent = assoc.srcInformationFlow_refport_parent();
			portPair.dstRoleName = "dstInformationFlow";
			portPair.dst.port = assoc.dstInformationFlow_end();
			portPair.dst.port_ref_parent = assoc.dstInformationFlow_refport_parent();
		} 
		else if (type == ExecutionAssignment::meta) 
		{
			ExecutionAssignment assoc = ExecutionAssignment::Cast(conn);
			portPair.srcRoleName = "srcExecutionAssignment";
			portPair.src.port = assoc.srcExecutionAssignment_end();
			portPair.src.port_ref_parent = assoc.srcExecutionAssignment_refport_parent();
			portPair.dstRoleName = "dstExecutionAssignment";
			portPair.dst.port = assoc.dstExecutionAssignment_end();
			portPair.dst.port_ref_parent = assoc.dstExecutionAssignment_refport_parent();
	
		} 
		else if (type == JoinStructures::meta)
		{
			JoinStructures assoc = JoinStructures::Cast(conn);
			portPair.srcRoleName = "srcJoinStructures";
			portPair.src.port = assoc.srcJoinStructures_end();
			portPair.src.port_ref_parent = assoc.srcJoinStructures_refport_parent();
			portPair.dstRoleName = "dstJoinStructures";
			portPair.dst.port = assoc.dstJoinStructures_end();
			portPair.dst.port_ref_parent = assoc.dstJoinStructures_refport_parent();
		} 
		else if (type == RefCoordSystem2RefCoordSystem::meta)
		{
			RefCoordSystem2RefCoordSystem assoc = RefCoordSystem2RefCoordSystem::Cast(conn);
			portPair.srcRoleName = "srcRefCoordSystem2RefCoordSystem";
			portPair.src.port = assoc.srcRefCoordSystem2RefCoordSystem_end();
			portPair.src.port_ref_parent = assoc.srcRefCoordSystem2RefCoordSystem_refport_parent();
			portPair.dstRoleName = "dstRefCoordSystem2RefCoordSystem";
			portPair.dst.port = assoc.dstRefCoordSystem2RefCoordSystem_end();
			portPair.dst.port_ref_parent = assoc.dstRefCoordSystem2RefCoordSystem_refport_parent();
		}
		else if (type == AggregatePortComposition::meta)
		{
			AggregatePortComposition assoc = AggregatePortComposition::Cast(conn);
			portPair.srcRoleName = "srcAggregatePortComposition";
			portPair.src.port = assoc.srcAggregatePortComposition_end();
			portPair.src.port_ref_parent = assoc.srcAggregatePortComposition_refport_parent();
			portPair.dstRoleName = "dstAggregatePortComposition";
			portPair.dst.port = assoc.dstAggregatePortComposition_end();
			portPair.dst.port_ref_parent = assoc.dstAggregatePortComposition_refport_parent();
		}
		else if(type == CyPhyML::AnalysisPointMap::meta)
		{
			AnalysisPointMap assoc = AnalysisPointMap::Cast(conn);
			portPair.srcRoleName = "srcAnalysisPointMap";
			portPair.src.port = assoc.srcAnalysisPointMap_end();
			portPair.src.port_ref_parent = assoc.srcAnalysisPointMap_refport_parent();
			portPair.dstRoleName = "dstAnalysisPointMap";
			portPair.dst.port = assoc.dstAnalysisPointMap_end();
			portPair.dst.port_ref_parent = assoc.dstAnalysisPointMap_refport_parent();		
		}
		else if(type == CyPhyML::ModelicaPort2ComponentPortPowerFlow::meta)
		{
			ModelicaPort2ComponentPortPowerFlow assoc = ModelicaPort2ComponentPortPowerFlow::Cast(conn);
			portPair.srcRoleName = "srcModelicaPort2ComponentPortPowerFlow";
			portPair.src.port = assoc.srcModelicaPort2ComponentPortPowerFlow_end();
			portPair.src.port_ref_parent = assoc.srcModelicaPort2ComponentPortPowerFlow_refport_parent();
			portPair.dstRoleName = "dstModelicaPort2ComponentPortPowerFlow";
			portPair.dst.port = assoc.dstModelicaPort2ComponentPortPowerFlow_end();
			portPair.dst.port_ref_parent = assoc.dstModelicaPort2ComponentPortPowerFlow_refport_parent();			
		}
		else
			throw udm_exception(std::string("Unknown composition type ") + static_cast<std::string>(type.name()));

		return portPair;
	};

	bool isSamePort(ComponentPort &port1, ComponentPort &port2)
	{
		return (port1.port==port2.port && port1.port_ref_parent==port2.port_ref_parent);
	};


	Udm::Object reconstructConnection(const Uml::Class &type,  const Udm::Object& parent, 
									  const Udm::Object &end1, const CyPhyML::ComponentRef &end1_comref, 
									  const Udm::Object &end2, const CyPhyML::ComponentRef &end2_comref)
	{
		if(Uml::IsDerivedFrom(type, CyPhyML::Composition::meta))
		{
			return createComposition(type,end1,end2,parent,end1_comref, end2_comref);
		}
		else if(Uml::IsDerivedFrom(type, CyPhyML::ValueFlow::meta))
		{
			ValueFlow newVF = ValueFlow::Create(parent);
			if (end1_comref)
				newVF.srcValueFlow_refport_parent() = ValueFlow_srcValueFlow_RPContainer_Base::Cast(end1_comref);
			if (end2_comref)
				newVF.dstValueFlow_refport_parent() = ValueFlow_dstValueFlow_RPContainer_Base::Cast(end2_comref);
			newVF.srcValueFlow_end() = ValueFlowTarget::Cast(end1);
			newVF.dstValueFlow_end() = ValueFlowTarget::Cast(end2);
			return newVF;
		}
		else if(Uml::IsDerivedFrom(type, CyPhyML::AssignJoinData::meta))
		{
			CyPhyML::AssignJoinData newajd = CyPhyML::AssignJoinData::Create(parent);
			if (end2_comref)
				newajd.dstAssignJoinData_refport_parent() = CyPhyML::AssignJoinData_dstAssignJoinData_RPContainer_Base::Cast(end2_comref);
			newajd.srcAssignJoinData_end() = JoinData::Cast(end1);
			newajd.dstAssignJoinData_end() = StructuralPortType::Cast(end2);
			return newajd;
		}
		else
			throw udm_exception(std::string("Unknown connection type ") + static_cast<std::string>(type.name()));
	};

	//Udm::Object createComposition(const Uml::Class &type,const CyPhyML::Port& src,const CyPhyML::Port& dst,
	//							  const Udm::Object& parent,const Udm::Object& srcRefParent,const Udm::Object& dstRefParent)
	
	Udm::Object createComposition(const Uml::Class &type,const Udm::Object& src,const Udm::Object& dst,
								  const Udm::Object& parent,const Udm::Object& srcRefParent,const Udm::Object& dstRefParent)
	{
		if (type == PowerFlow::meta) {
			PowerFlow assoc = PowerFlow::Create(parent);
			if (srcRefParent)
				assoc.srcPowerFlow_refport_parent() = PowerFlow_srcPowerFlow_RPContainer_Base::Cast(srcRefParent);
			if (dstRefParent)
				assoc.dstPowerFlow_refport_parent() = PowerFlow_dstPowerFlow_RPContainer_Base::Cast(dstRefParent);
			assoc.srcPowerFlow_end() = PowerPortType::Cast(src);
			assoc.dstPowerFlow_end() = PowerPortType::Cast(dst);
			return assoc;
		} else if (type == InformationFlow::meta) {
			InformationFlow assoc = InformationFlow::Create(parent);
			if (srcRefParent)
				assoc.srcInformationFlow_refport_parent() = InformationFlow_srcInformationFlow_RPContainer_Base::Cast(srcRefParent);
			if (dstRefParent)
				assoc.dstInformationFlow_refport_parent() = InformationFlow_dstInformationFlow_RPContainer_Base::Cast(dstRefParent);
			assoc.srcInformationFlow_end() = SignalPortType::Cast(src);
			assoc.dstInformationFlow_end() = SignalPortType::Cast(dst);
			return assoc;
		} else if (type == ExecutionAssignment::meta) {
			ExecutionAssignment assoc = ExecutionAssignment::Create(parent);
			if (srcRefParent)
				assoc.srcExecutionAssignment_refport_parent() = ExecutionAssignment_srcExecutionAssignment_RPContainer_Base::Cast(srcRefParent);
			if (dstRefParent)
				assoc.dstExecutionAssignment_refport_parent() = ExecutionAssignment_dstExecutionAssignment_RPContainer_Base::Cast(dstRefParent);
			assoc.srcExecutionAssignment_end() = ExecutionAssignment_Members_Base::Cast(src);
			assoc.dstExecutionAssignment_end() = ExecutionAssignment_Members_Base::Cast(dst);
			return assoc;
		} else if (type == JoinStructures::meta) {
			JoinStructures assoc = JoinStructures::Create(parent);
			if (srcRefParent)
				assoc.srcJoinStructures_refport_parent() = JoinStructures_srcJoinStructures_RPContainer_Base::Cast(srcRefParent);
			if (dstRefParent)
				assoc.dstJoinStructures_refport_parent() = JoinStructures_dstJoinStructures_RPContainer_Base::Cast(dstRefParent);
			assoc.srcJoinStructures_end() = StructuralPortType::Cast(src);
			assoc.dstJoinStructures_end() = StructuralPortType::Cast(dst);
			return assoc;
		} else if (type == RefCoordSystem2RefCoordSystem::meta) {
			RefCoordSystem2RefCoordSystem assoc = RefCoordSystem2RefCoordSystem::Create(parent);
			if (srcRefParent)
				assoc.srcRefCoordSystem2RefCoordSystem_refport_parent() = RefCoordSystem2RefCoordSystem_srcRefCoordSystem2RefCoordSystem_RPContainer_Base::Cast(srcRefParent);
			if (dstRefParent)
				assoc.dstRefCoordSystem2RefCoordSystem_refport_parent() = RefCoordSystem2RefCoordSystem_dstRefCoordSystem2RefCoordSystem_RPContainer_Base::Cast(dstRefParent);
			assoc.srcRefCoordSystem2RefCoordSystem_end() = ReferenceCoordinateSystem::Cast(src);
			assoc.dstRefCoordSystem2RefCoordSystem_end() = ReferenceCoordinateSystem::Cast(dst);
			return assoc;
		} else if (type == AggregatePortComposition::meta) {
			AggregatePortComposition assoc = AggregatePortComposition::Create(parent);
			if (srcRefParent)
				assoc.srcAggregatePortComposition_refport_parent() = CyPhyML::AggregatePortComposition_srcAggregatePortComposition_RPContainer_Base::Cast(srcRefParent);
			if (dstRefParent)
				assoc.dstAggregatePortComposition_refport_parent() = CyPhyML::AggregatePortComposition_dstAggregatePortComposition_RPContainer_Base::Cast(dstRefParent);
			assoc.srcAggregatePortComposition_end() = AggregatePort::Cast(src);
			assoc.dstAggregatePortComposition_end() = AggregatePort::Cast(dst);
			return assoc;
		}
		else if(type == CyPhyML::AnalysisPointMap::meta)
		{
			AnalysisPointMap assoc = AnalysisPointMap::Create(parent);
			if (srcRefParent)
				assoc.srcAnalysisPointMap_refport_parent() = CyPhyML::AnalysisPointMap_srcAnalysisPointMap_RPContainer_Base::Cast(srcRefParent);
			if (dstRefParent)
				assoc.dstAnalysisPointMap_refport_parent() = CyPhyML::AnalysisPointMap_dstAnalysisPointMap_RPContainer_Base::Cast(dstRefParent);
			assoc.srcAnalysisPointMap_end() = AnalysisFeatures::Cast(src);
			assoc.dstAnalysisPointMap_end() = AnalysisFeatures::Cast(dst);
			return assoc;
		}
		else if(type == CyPhyML::ModelicaPort2ComponentPortPowerFlow::meta)
		{
			ModelicaPort2ComponentPortPowerFlow assoc = ModelicaPort2ComponentPortPowerFlow::Create(parent);
			if(srcRefParent)
				assoc.srcModelicaPort2ComponentPortPowerFlow_refport_parent() = CyPhyML::ModelicaPort2ComponentPortPowerFlow_srcModelicaPort2ComponentPortPowerFlow_RPContainer_Base::Cast(srcRefParent);
			if(dstRefParent)
				assoc.dstModelicaPort2ComponentPortPowerFlow_refport_parent() = CyPhyML::ModelicaPort2ComponentPortPowerFlow_dstModelicaPort2ComponentPortPowerFlow_RPContainer_Base::Cast(dstRefParent);
			assoc.srcModelicaPort2ComponentPortPowerFlow_end() = CyPhyML::ModelicaPort2ComponentPortPowerFlow_Members_Base::Cast(src);
			assoc.dstModelicaPort2ComponentPortPowerFlow_end() = CyPhyML::ModelicaPort2ComponentPortPowerFlow_Members_Base::Cast(dst);
			return assoc;
		}
		throw udm_exception(std::string("Unknown composition type ") + static_cast<std::string>(type.name()));	
	};
};

#endif