/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Newtonsoft.Json;

namespace WorkflowDecorator
{
    public partial class ParameterSettingsForm : Form
    {
        public class Parameter
        {
            public string Name { get; set; }
            public string Value { get; set; }
        }

        public List<Parameter> parameters;
        public ParameterSettingsForm(List<Parameter> list)
        {
            InitializeComponent();
            parameters = list;

            this.parameterGridView.DataSource = parameters;
            foreach (var item in this.parameterGridView.Columns)
            {
                (item as DataGridViewColumn).SortMode = DataGridViewColumnSortMode.Automatic;
                (item as DataGridViewColumn).HeaderCell.SortGlyphDirection = SortOrder.None;
            }
            parameterGridView.Columns[0].ReadOnly = true;
            (parameterGridView.Columns[0] as DataGridViewColumn).HeaderCell.SortGlyphDirection = SortOrder.Ascending;
            (parameterGridView.Columns[1] as DataGridViewColumn).AutoSizeMode = DataGridViewAutoSizeColumnMode.Fill;
            parameters.Sort(new ParameterComparor() { columnName = "Name" });
        }


        private void parameterGridView_ColumnHeaderMouseClick(object sender, DataGridViewCellMouseEventArgs e)
        {
            string columnName = parameterGridView.Columns[e.ColumnIndex].Name;
            parameters.Sort(new ParameterComparor() { columnName = columnName });
            foreach (DataGridViewColumn column in parameterGridView.Columns)
            {
                column.HeaderCell.SortGlyphDirection = SortOrder.None;
            }
            parameterGridView.Columns[e.ColumnIndex].HeaderCell.SortGlyphDirection = SortOrder.Ascending;
            parameterGridView.DataSource = null;
            parameterGridView.DataSource = parameters;
            (parameterGridView.Columns[1] as DataGridViewColumn).AutoSizeMode = DataGridViewAutoSizeColumnMode.Fill;
        }

        class ParameterComparor : IComparer<Parameter>
        {
            public string columnName { get; set; }
            public int Compare(Parameter x, Parameter y)
            {
                return ((IComparable)x.GetType().GetProperty(columnName).GetValue(x, null))
                    .CompareTo(y.GetType().GetProperty(columnName).GetValue(y, null));
            }
        }
    }
}
