/* NAME:	GReAT Sort
 * AUTHOR:	Attila Vizhanyo - viza@isis.vanderbilt.edu
 *
 * Helper templates for GReAT sorting
 */

#ifndef GREATSORT_H
#define GREATSORT_H

#include <vector>
#include <list>
#include <functional>

///////////////////////////////////////////////////////////////////////////////
template< class T, class ELEM>
void permutate( const std::vector< T> permVec, std::list< ELEM>& toPermutate)
{
	T currPos= 0;
	typedef std::vector< ELEM> PacketsVec_t;
	PacketsVec_t copyPerm( permVec.size());
	for( typename std::list< ELEM>::const_iterator it= toPermutate.begin(); it!= toPermutate.end(); ++it, ++currPos) {
		copyPerm[ permVec[ currPos]]= *it;
	}
	std::copy( copyPerm.begin(), copyPerm.end(), toPermutate.begin());
}

///////////////////////////////////////////////////////////////////////////////
template <class T>
class NeitherPredicate
{
public:
	typedef std::pointer_to_binary_function< const T&, const T&, bool> Predicate_t;
	NeitherPredicate( const Predicate_t& predicate) 
		: _predicate( predicate)
	{}
	bool operator()( const T& lhs, const T& rhs) const{
		return ! ( _predicate( lhs, rhs) || _predicate( rhs, lhs));
	}
private:
	Predicate_t _predicate;
};

#endif //GREATSORT_H
