/* NAME:	GenerateRTT.h
 * AUTHORS:	
 *	Feng Shi - fengshi@isis.vanderbilt.edu
 *
 * Utility functions for generating RTT model.
 */

#ifndef __RTTGENERATOR_H
#define __RTTGENERATOR_H

#ifdef _MSC_VER
#pragma warning (disable : 4786)
#pragma warning (disable : 4503) 
#endif

#include "RTT.h"
#include "UdmUtil.h"

#ifdef _DEBUG
#define GREAT_RTT_DEBUG_D "d"
#else
#define GREAT_RTT_DEBUG_D ""
#endif
#if (_MSC_VER == 1600) /* VS2010 */
#pragma comment(lib, "RTTGeneratorVC10" GREAT_RTT_DEBUG_D ".lib")
#else
#pragma comment(lib, "RTTGenerator" GREAT_RTT_DEBUG_D ".lib")
#endif /* _MSC_VER == 1600 */


class RTTGenerator
{
public:
	static RTTGenerator* Instance();
	static RTTGenerator* Instance(const std::string& file_path, const std::string& rttRoot="");
	
	void generateDataNetwork(int id, const std::string &filepath, const std::string& name="");
	void generateRule(int id, const std::string &name);
	void generateRTT(int srcId, int srcDNId, const std::string& srcName,
			         int dstId, int dstDNId, const std::string& dstName);
	void close();
	static void convertUdmCopyMap(const UdmUtil::copy_assoc_map& copyMap, map<int, int>& copyIdMap, bool reverse);
	void addUdmCopyMap(int workDNId, map<int, int>& udmCopyMap);

protected:
	RTTGenerator();
	RTTGenerator(const std::string& file_path);

private:
	static RTTGenerator* _instance;
	static std::string _rttRootName;
	std::string _filePath;
	int _ruleCounter;
	Udm::SmartDataNetwork* _rttdn;
	RTT::RTTRoot _rttRoot;
	RTT::ExecuteRule _currRule;
	map< pair<int, int>, RTT::UdmObject> _currObjMap;
	map<int, map<int, int> > _dnUdmCopyMap;
};

#endif