#include "ctest-gr_userinc.h"

template <class T>
bool ArgOrder( const T& lhs, const T& rhs) {
	__int64 l = lhs.argIndex();
__int64 r = rhs.argIndex();
return (l < r);
}

template <class BASE, class T>
bool ArgOrder_caster( const BASE& lhs, const BASE& rhs) {
	T lhs_casted= T::Cast( lhs);
	T rhs_casted= T::Cast( rhs);
	return ArgOrder( lhs_casted, rhs_casted);
}

template <class T>
bool StatementOrder( const T& lhs, const T& rhs) {
	__int64 l = lhs.statementIndex();
__int64 r = rhs.statementIndex();
return (l < r);
}

template <class BASE, class T>
bool StatementOrder_caster( const BASE& lhs, const BASE& rhs) {
	T lhs_casted= T::Cast( lhs);
	T rhs_casted= T::Cast( rhs);
	return StatementOrder( lhs_casted, rhs_casted);
}

