/* GenESM2SLC_main.cpp generated on Mon Jul 23 16:50:55 2012
 */

#include "GenESM2SLC.h"
#include "InputFileRegistry.h"
#include "UdmDom.h"
#include "UdmGme.h"
#include "RTTGenerator.h"
#include "GReATUtils.h"
#include <direct.h>

// Extern global temporary root object(s).
void usage()
{
	std::cout << "Usage:  TL.exe ESMoL=\"SFControl7.mga\"!\"Udm\\\"  SFC=\"SFControl_slc.xml\"!\"Udm\\SFC.xsd\"  or\n\tTL -d\n\n";
}

int main( int argc, char* argv[])
{
	InputFileRegistry ifr;
	ifr.registerFile( "ESMoL=\"SFControl7.mga\"!\"Udm\\\" ");
	ifr.registerFile( "SFC=\"SFControl_slc.xml\"!\"Udm\\SFC.xsd\" ");
	if( argc== 1)
	{
		usage( );
		return -1;
	}
	else
		if( ( argc== 2)&& ( std::string( argv[ 1])== "-d"))
			std::cout << "Executing with default arguments." << std::endl;
		else
			for( int i= 1; i<argc; ++i)
			{
				if( false== ifr.registerFile( argv[ i]))
					throw InputFileEx( std::string( "Invalid input file expression: ") + argv[ i]);
			}
	try
	{
		// Initialize RTT
		char cwd[_MAX_PATH];
		_getcwd(cwd, _MAX_PATH);
		UdmUtil::copy_assoc_map udm_copyMap;
		map<int, int> rtt_copyIdMap;
		std::string rttname("RTT");
		rttname.append("_");
		rttname.append(dropExtension(dropPath(ifr.getFileName( "ESMoL"))));
		rttname.append("_");
		rttname.append(dropExtension(dropPath(ifr.getFileName( "SFC"))));
		RTTGenerator::Instance(getFullPath((std::string)cwd,rttname).append(".mga"), rttname);
		// 
		std::vector< Udm::StaticDataNetworkSpecifier> dnsvec;
		// Open ESMoL r
		Udm::SmartDataNetwork sdnESMoL_4c93( ESMoL::diagram);
		sdnESMoL_4c93.OpenExisting( ifr.getFileName( "ESMoL"), UseXSD()( ifr.getFileName( "ESMoL")) ? ifr.getXsdName( "ESMoL") : "ESMoL", Udm::CHANGES_LOST_DEFAULT);
		RTTGenerator::Instance()->generateDataNetwork(sdnESMoL_4c93.testdn()->uniqueId(), getFullPath((std::string)cwd,ifr.getFileName( "ESMoL")), dropPath(ifr.getFileName( "ESMoL")));
		Udm::StaticDataNetworkSpecifier sdns_ESMoL_4c94( ifr.getFileName( "ESMoL"), &sdnESMoL_4c93);
		dnsvec.push_back( sdns_ESMoL_4c94);
		// Open SFC w
		Udm::SmartDataNetwork sdnSFC_4c96( SFC::diagram);
		sdnSFC_4c96.CreateNew( ifr.getFileName( "SFC"), UseXSD()( ifr.getFileName( "SFC")) ? ifr.getXsdName( "SFC") : "SFC", SFC::Project::meta, Udm::CHANGES_LOST_DEFAULT);
		RTTGenerator::Instance()->generateDataNetwork(sdnSFC_4c96.testdn()->uniqueId(), getFullPath((std::string)cwd,ifr.getFileName( "SFC")), dropPath(ifr.getFileName( "SFC")));
		Udm::StaticDataNetworkSpecifier sdns_SFC_4c97( ifr.getFileName( "SFC"), &sdnSFC_4c96);
		dnsvec.push_back( sdns_SFC_4c97);
		// Create the project
		Udm::StaticUdmProject prj( dnsvec, ESM2SLC::diagram);
		Udm::DataNetwork& eSMoL_ref_4c95= prj.GetDataNetwork( ifr.getFileName( "ESMoL"));
		Udm::DataNetwork& sFC_ref_4c98= prj.GetDataNetwork( ifr.getFileName( "SFC"));
		Packets_t dataflows_2b84;
		Packets_t projects_2b86;
		// get objects from DNs
		ESMoL::RootFolder rootESMoL_4c99= ESMoL::RootFolder::Cast( eSMoL_ref_4c95.GetRootObject());
		std::set< ESMoL::Dataflow> dataflows_4c9a= rootESMoL_4c99.Dataflow_kind_children();
		for( std::set< ESMoL::Dataflow>::const_iterator itdataflows_4c9a= dataflows_4c9a.begin(); itdataflows_4c9a!= dataflows_4c9a.end(); ++itdataflows_4c9a)
		{
			const ESMoL::Dataflow& currDataflow_4c9b= *itdataflows_4c9a;
			SFC::Project rootSFC_4c9c= SFC::Project::Cast( sFC_ref_4c98.GetRootObject());
			// Add objects to input packets.
			dataflows_2b84.push_back( currDataflow_4c9b);
			projects_2b86.push_back( rootSFC_4c9c);
		}
		// Get access to temporary root object(s).
		// transformation
		TL_2b83 tL_2b83;
		tL_2b83( dataflows_2b84, projects_2b86);
		// Close the project
		prj.Close();
		sdnESMoL_4c93.CloseNoUpdate();
		sdnSFC_4c96.CloseWithUpdate();
		// close RTT model
		RTTGenerator::Instance()->close();
	}
	catch( udm_exception &e)
	{
		cout << e.what() << endl;
	}
	return 0;
}

