#ifndef ESMoL_xsd_H
#define ESMoL_xsd_H
#include <string>
#pragma warning( disable : 4010)

namespace ESMoL_xsd
{
const std::string& getString()
{
	static std::string str;
	if (str.empty())
	{
		str +="<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
		str +="<?udm interface=\"ESMoL\" version=\"1.00\"?>\n";
		str +="<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n";
		str +=" elementFormDefault=\"qualified\" \n";
		str +=">\n";
//		str +="<!-- generated on Mon Jul 23 16:51:09 2012 -->\n";
		str +="\n";
		str +="\n";
		str +="	<xsd:complexType name=\"FaultScenarioType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"CCode\" type=\"CCodeType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"CompBreakout\" type=\"CompBreakoutType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ConditionEvent\" type=\"ConditionEventType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"DesignReference\" type=\"DesignReferenceType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"DetectionAction\" type=\"DetectionActionType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"DetectionCondition\" type=\"DetectionConditionType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"FaultCondition\" type=\"FaultConditionType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"FaultMgrTask\" type=\"FaultMgrTaskType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"FaultModel\" type=\"FaultModelType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"FaultModelRef\" type=\"FaultModelRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"FaultToInput\" type=\"FaultToInputType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"FaultTrigger\" type=\"FaultTriggerType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"MitigationAction\" type=\"MitigationActionType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"MitigationCondition\" type=\"MitigationConditionType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"OutputToFault\" type=\"OutputToFaultType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PetriNet\" type=\"PetriNetType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PetriNetRef\" type=\"PetriNetRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Postcondition\" type=\"PostconditionType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Precondition\" type=\"PreconditionType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ScenarioInfo\" type=\"ScenarioInfoType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Subsystem\" type=\"SubsystemType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"SubsystemRef\" type=\"SubsystemRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"TaskInst\" type=\"TaskInstType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ScenarioInfoType\">\n";
		str +="		<xsd:attribute name=\"Requirements\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ScenarioDescription\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Criticality\" type=\"xsd:string\" default=\"C\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"FaultEventType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"FaultEvent\" type=\"FaultEventType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyFaultTrigger\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_libname\" type=\"xsd:string\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"FaultTriggerType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"FaultConditionType\">\n";
		str +="		<xsd:attribute name=\"Expression\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ConditionEventType\">\n";
		str +="		<xsd:attribute name=\"Expression\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyFaultTrigger\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PreconditionType\">\n";
		str +="		<xsd:attribute name=\"Expression\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PostconditionType\">\n";
		str +="		<xsd:attribute name=\"Expression\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"DetectionConditionType\">\n";
		str +="		<xsd:attribute name=\"Expression\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"MitigationConditionType\">\n";
		str +="		<xsd:attribute name=\"Expression\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TaskInstType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"srcCompBreakout\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"DetectionActionType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"MitigationActionType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"FaultMgrTaskType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"CompBreakoutType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcCompBreakout_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstCompBreakout_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"DesignReferenceType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"FaultToInputType\">\n";
		str +="		<xsd:attribute name=\"VectorIndex\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcFaultToInput_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstFaultToInput_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"OutputToFaultType\">\n";
		str +="		<xsd:attribute name=\"VectorIndex\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcOutputToFault_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstOutputToFault_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"FaultModelRefType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"FaultModelType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Variable\" type=\"VariableType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyFaultModelRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AdditiveType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"SubstitutiveType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ContinuousType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PeriodicType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"IntermittentType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"MultiplicativeType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"VariableType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Additive\" type=\"AdditiveType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Constant\" type=\"ConstantType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Continuous\" type=\"ContinuousType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Exponential\" type=\"ExponentialType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Intermittent\" type=\"IntermittentType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Multiplicative\" type=\"MultiplicativeType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Normal\" type=\"NormalType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Periodic\" type=\"PeriodicType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Pulse\" type=\"PulseType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Sinusoid\" type=\"SinusoidType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Step\" type=\"StepType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Substitutive\" type=\"SubstitutiveType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Uniform\" type=\"UniformType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcFaultToInput\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstFaultToInput\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcOutputToFault\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstOutputToFault\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"FaultModelFolderType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"FaultModel\" type=\"FaultModelType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ConstantType\">\n";
		str +="		<xsd:attribute name=\"Value\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"IntervalType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Interval\" type=\"IntervalType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Range\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_libname\" type=\"xsd:string\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"UniformType\">\n";
		str +="		<xsd:attribute name=\"LowerBound\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"UpperBound\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"NormalType\">\n";
		str +="		<xsd:attribute name=\"Mean\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"StdDev\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ExponentialType\">\n";
		str +="		<xsd:attribute name=\"Rate\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"SinusoidType\">\n";
		str +="		<xsd:attribute name=\"Frequency\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Phase\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"StepType\">\n";
		str +="		<xsd:attribute name=\"Shift\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PulseType\">\n";
		str +="		<xsd:attribute name=\"Shift\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Duration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TransitionToStateType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcTransitionToState_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstTransitionToState_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"StateToTransitionType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcStateToTransition_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstStateToTransition_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PNTransitionType\">\n";
		str +="		<xsd:attribute name=\"guard\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"action\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"dstTransitionToState\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcStateToTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PNStateType\">\n";
		str +="		<xsd:attribute name=\"initial\" type=\"xsd:boolean\" default=\"false\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcTransitionToState\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstStateToTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"BIPConnectorType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcPortToPort_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstPortToPort_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PNVarRefType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ModuleType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"BIPConnector\" type=\"BIPConnectorType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PetriNet\" type=\"PetriNetType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PetriNetType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"PNPort\" type=\"PNPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PNState\" type=\"PNStateType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PNTransition\" type=\"PNTransitionType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PNVariable\" type=\"PNVariableType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"StateToTransition\" type=\"StateToTransitionType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"TransitionToState\" type=\"TransitionToStateType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"action\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Period\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Deadline\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyPetriNetRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstCompBreakout\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PNPortType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"PNVarRef\" type=\"PNVarRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"visible\" type=\"xsd:boolean\" default=\"false\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyFaultTrigger\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcPortToPort\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstPortToPort\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTrigger\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTrigger\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PNVariableType\">\n";
		str +="		<xsd:attribute name=\"datatype\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcFaultToInput\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstFaultToInput\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcOutputToFault\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstOutputToFault\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"referedbyPNVarRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcIOPortAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcConnector\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstConnector\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ModelsFolderType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Dataflow\" type=\"DataflowType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ModelInfo\" type=\"ModelInfoType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Module\" type=\"ModuleType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Stateflow\" type=\"StateflowType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ModelInfoType\">\n";
		str +="		<xsd:attribute name=\"ModelPath\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"DateTimeStamp\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TTExecInfoType\">\n";
		str +="		<xsd:attribute name=\"WCDuration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RelDeadline\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"TTSchedule\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ExecPeriod\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"DesiredOffset\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"dstExecutionAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AsyncPeriodicExecInfoType\">\n";
		str +="		<xsd:attribute name=\"WCDuration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RelDeadline\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"TerminationTime\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ExecPeriod\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"DesiredOffset\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"dstExecutionAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TTExecContextType\">\n";
		str +="		<xsd:attribute name=\"Hyperperiod\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ExecutionAssignmentType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"dstExecutionAssignment__rp_helper\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"srcExecutionAssignment_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstExecutionAssignment_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"SporadicExecInfoType\">\n";
		str +="		<xsd:attribute name=\"WCDuration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RelDeadline\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"MinimumPeriod\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"dstExecutionAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"CCodeType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"CInputPort\" type=\"CInputPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"COutputPort\" type=\"COutputPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"CodeInfo\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Period\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Deadline\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"dstCompBreakout\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"SubsystemRefType\">\n";
		str +="		<xsd:attribute name=\"Period\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Deadline\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstConnector__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcConnector__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstCompBreakout\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"COutputPortType\">\n";
		str +="		<xsd:attribute name=\"CPortType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcOutputToFault\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstOutputToFault\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcIOPortAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstConnector\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"CInputPortType\">\n";
		str +="		<xsd:attribute name=\"CPortType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcFaultToInput\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstFaultToInput\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcIOPortAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcConnector\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PetriNetRefType\">\n";
		str +="		<xsd:attribute name=\"Period\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Deadline\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstConnector__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcConnector__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstCompBreakout\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"CANMessageType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"AutoCANParam\" type=\"AutoCANParamType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"MsgPort\" type=\"MsgPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Priority\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Period\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"MsgSize\" type=\"xsd:string\" default=\"1B\"/>\n";
		str +="		<xsd:attribute name=\"MsgMetaData\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyBusMessageRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AutoCANParamType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"BitField\" type=\"BitFieldType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ValueType\" type=\"ValueTypeType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"SPN\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"MsgPortNum\" type=\"xsd:long\" default=\"-1\"/>\n";
		str +="		<xsd:attribute name=\"FieldMetaData\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcFaultToInput\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstFaultToInput\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcOutputToFault\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstOutputToFault\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcIOPortAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcConnector\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstConnector\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AutoCANMessageType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"AutoCANParam\" type=\"AutoCANParamType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"MsgPort\" type=\"MsgPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Priority\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Period\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"PGN\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"MsgSize\" type=\"xsd:string\" default=\"1B\"/>\n";
		str +="		<xsd:attribute name=\"MsgMetaData\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyBusMessageRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"BitFieldType\">\n";
		str +="		<xsd:attribute name=\"NumBits\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"InitialValue\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ValueTypeType\">\n";
		str +="		<xsd:attribute name=\"NumBits\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"InitialValue\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Scale\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Signed\" type=\"xsd:boolean\" default=\"false\"/>\n";
		str +="		<xsd:attribute name=\"DataType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"MinValue\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"MaxValue\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Units\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Offset\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TTBusType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TTExecContext\" type=\"TTExecContextType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Hyperperiod\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"TTSetupTime\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"SlotSize\" type=\"xsd:string\" default=\"512B\"/>\n";
		str +="		<xsd:attribute name=\"Configuration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"DataRate\" type=\"xsd:string\" default=\"1b\"/>\n";
		str +="		<xsd:attribute name=\"DeprecatedOH\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"MinFrameSize\" type=\"xsd:string\" default=\"512B\"/>\n";
		str +="		<xsd:attribute name=\"SwitchMemorySize\" type=\"xsd:string\" default=\"80MB\"/>\n";
		str +="		<xsd:attribute name=\"ID\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"SetupTime\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcWire\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstWire\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"OldBusType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TTExecContext\" type=\"TTExecContextType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Medium\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"FrameSize\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"OverheadTime\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"Configuration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"DataRate\" type=\"xsd:string\" default=\"1b\"/>\n";
		str +="		<xsd:attribute name=\"DeprecatedOH\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"MinFrameSize\" type=\"xsd:string\" default=\"512B\"/>\n";
		str +="		<xsd:attribute name=\"SwitchMemorySize\" type=\"xsd:string\" default=\"80MB\"/>\n";
		str +="		<xsd:attribute name=\"ID\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"SetupTime\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcWire\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstWire\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"CANBusType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TTExecContext\" type=\"TTExecContextType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Hyperperiod\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"Configuration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"DataRate\" type=\"xsd:string\" default=\"1b\"/>\n";
		str +="		<xsd:attribute name=\"DeprecatedOH\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"MinFrameSize\" type=\"xsd:string\" default=\"512B\"/>\n";
		str +="		<xsd:attribute name=\"SwitchMemorySize\" type=\"xsd:string\" default=\"80MB\"/>\n";
		str +="		<xsd:attribute name=\"ID\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"SetupTime\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcWire\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstWire\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"SerialLinkType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TTExecContext\" type=\"TTExecContextType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"DataBits\" type=\"xsd:long\" default=\"8\"/>\n";
		str +="		<xsd:attribute name=\"Parity\" type=\"xsd:boolean\" default=\"false\"/>\n";
		str +="		<xsd:attribute name=\"StopBits\" type=\"xsd:long\" default=\"1\"/>\n";
		str +="		<xsd:attribute name=\"FlowControl\" type=\"xsd:string\" default=\"None\"/>\n";
		str +="		<xsd:attribute name=\"Configuration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"DataRate\" type=\"xsd:string\" default=\"1b\"/>\n";
		str +="		<xsd:attribute name=\"DeprecatedOH\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"MinFrameSize\" type=\"xsd:string\" default=\"512B\"/>\n";
		str +="		<xsd:attribute name=\"SwitchMemorySize\" type=\"xsd:string\" default=\"80MB\"/>\n";
		str +="		<xsd:attribute name=\"ID\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"SetupTime\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcWire\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstWire\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"IOPortInfoType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"IOPortInfo\" type=\"IOPortInfoType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"DataSize\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"DataInit\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"DataMin\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"DataMax\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Scale\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Offset\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyIOPortInfoRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstIOPortAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_libname\" type=\"xsd:string\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"IOPortInfoRefType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"IOPortInfoRef\" type=\"IOPortInfoRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstIOPortAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_libname\" type=\"xsd:string\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"IOPortAssignmentType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"IOPortAssignment\" type=\"IOPortAssignmentType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcIOPortAssignment_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstIOPortAssignment_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_libname\" type=\"xsd:string\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"OldTaskType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"OldTask\" type=\"OldTaskType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Priority\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"TaskType\" type=\"xsd:string\" default=\"AUTO\"/>\n";
		str +="		<xsd:attribute name=\"Activation\" type=\"xsd:long\" default=\"1\"/>\n";
		str +="		<xsd:attribute name=\"AutoStart\" type=\"xsd:boolean\" default=\"true\"/>\n";
		str +="		<xsd:attribute name=\"Preemption\" type=\"xsd:string\" default=\"FULL\"/>\n";
		str +="		<xsd:attribute name=\"Cyclic\" type=\"xsd:boolean\" default=\"false\"/>\n";
		str +="		<xsd:attribute name=\"CycleTime\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_libname\" type=\"xsd:string\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ArchitectureLibraryType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"SystemTypes\" type=\"SystemTypesType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"SystemTypesType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"AutoCANMessage\" type=\"AutoCANMessageType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"CANMessage\" type=\"CANMessageType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Component\" type=\"ComponentType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Message\" type=\"MessageType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PlantComponent\" type=\"PlantComponentType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ConnectorType\">\n";
		str +="		<xsd:attribute name=\"ConnectionType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"dstConnector__rp_helper\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"srcConnector__rp_helper\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"srcConnector_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstConnector_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"MessageType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"AutoCANParam\" type=\"AutoCANParamType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"MsgPort\" type=\"MsgPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"MsgSize\" type=\"xsd:string\" default=\"1B\"/>\n";
		str +="		<xsd:attribute name=\"MsgMetaData\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyBusMessageRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"MsgPortType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"BitField\" type=\"BitFieldType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ValueType\" type=\"ValueTypeType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"MsgPortNum\" type=\"xsd:long\" default=\"-1\"/>\n";
		str +="		<xsd:attribute name=\"FieldMetaData\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcFaultToInput\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstFaultToInput\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcOutputToFault\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstOutputToFault\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcIOPortAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcConnector\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstConnector\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TriggerType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcTrigger_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstTrigger_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PlantComponentType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"CCode\" type=\"CCodeType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Connector\" type=\"ConnectorType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"MessageRef\" type=\"MessageRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PetriNet\" type=\"PetriNetType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PetriNetRef\" type=\"PetriNetRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Subsystem\" type=\"SubsystemType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"SubsystemRef\" type=\"SubsystemRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Trigger\" type=\"TriggerType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"HeaderFiles\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"SourceFiles\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyTaskRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"referedbyComponentRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"DesignFolderType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"FaultModel\" type=\"FaultModelType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"FaultModelFolder\" type=\"FaultModelFolderType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"FaultScenario\" type=\"FaultScenarioType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"HardwareUnit\" type=\"HardwareUnitType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ModelsFolder\" type=\"ModelsFolderType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"System\" type=\"SystemType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"SystemTypes\" type=\"SystemTypesType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"TimingSheet\" type=\"TimingSheetType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ComponentType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"CCode\" type=\"CCodeType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Connector\" type=\"ConnectorType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"MessageRef\" type=\"MessageRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PetriNet\" type=\"PetriNetType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PetriNetRef\" type=\"PetriNetRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Subsystem\" type=\"SubsystemType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"SubsystemRef\" type=\"SubsystemRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Trigger\" type=\"TriggerType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"HeaderFiles\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"SourceFiles\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyTaskRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"referedbyComponentRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"MessageRefType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcFaultToInput\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstFaultToInput\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcOutputToFault\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstOutputToFault\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcCommMapping\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstCommMapping\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcExecutionAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcIOPortAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstConnector__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcConnector__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcConnector\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstConnector\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTrigger\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTrigger\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"referedbyBusMessageRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"srcDependency\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstDependency\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TimingConstraintType\">\n";
		str +="		<xsd:attribute name=\"Latency\" type=\"xsd:string\" default=\"1s\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcTimingConstraint_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstTimingConstraint_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"RequirementsLibraryType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TimingSheet\" type=\"TimingSheetType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TimingSheetType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TaskRef\" type=\"TaskRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"TimingConstraint\" type=\"TimingConstraintType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TaskRefType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcTimingConstraint\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTimingConstraint\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TypesType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Matrix\" type=\"MatrixType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"TypeStruct\" type=\"TypeStructType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TypeStructType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TypeBaseRef\" type=\"TypeBaseRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"MemberCount\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyTypeStructRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"MatrixType\">\n";
		str +="		<xsd:attribute name=\"Type\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"rows\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"columns\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyTypeStructRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TypeBaseRefType\">\n";
		str +="		<xsd:attribute name=\"MemberIndex\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PrimitiveType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"ActionPort\" type=\"ActionPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Annotation\" type=\"AnnotationType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ConnectorRef\" type=\"ConnectorRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"EnablePort\" type=\"EnablePortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"InputPort\" type=\"InputPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Line\" type=\"LineType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"OutputPort\" type=\"OutputPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Parameter\" type=\"ParameterType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"StatePort\" type=\"StatePortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"TriggerPort\" type=\"TriggerPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"BlockType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Tag\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Name\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Description\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Priority\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"SampleTime\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"UserData\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ParameterType\">\n";
		str +="		<xsd:attribute name=\"Value\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ReferenceType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"ActionPort\" type=\"ActionPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Annotation\" type=\"AnnotationType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ConnectorRef\" type=\"ConnectorRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"EnablePort\" type=\"EnablePortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"InputPort\" type=\"InputPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Line\" type=\"LineType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"OutputPort\" type=\"OutputPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Parameter\" type=\"ParameterType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"StatePort\" type=\"StatePortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"TriggerPort\" type=\"TriggerPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"BlockType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Tag\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Name\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Description\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Priority\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"SampleTime\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"UserData\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"SourceType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"SourceBlock\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AnnotationType\">\n";
		str +="		<xsd:attribute name=\"Text\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"LineType\">\n";
		str +="		<xsd:attribute name=\"Name\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcLine_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstLine_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"DataflowType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Subsystem\" type=\"SubsystemType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"SubsystemType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"ActionPort\" type=\"ActionPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Annotation\" type=\"AnnotationType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ConnectorRef\" type=\"ConnectorRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"EnablePort\" type=\"EnablePortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"InputPort\" type=\"InputPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Line\" type=\"LineType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"OutputPort\" type=\"OutputPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Parameter\" type=\"ParameterType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Primitive\" type=\"PrimitiveType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Reference\" type=\"ReferenceType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"StatePort\" type=\"StatePortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Subsystem\" type=\"SubsystemType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"TriggerPort\" type=\"TriggerPortType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Period\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Deadline\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"BlockType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Tag\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Name\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Description\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Priority\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"SampleTime\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"UserData\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbySubsystemRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstCompBreakout\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"OutputPortType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TypeBaseRef\" type=\"TypeBaseRefType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Number\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcOutputToFault\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstOutputToFault\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcIOPortAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstConnector\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcLine\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstLine\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"StatePortType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TypeBaseRef\" type=\"TypeBaseRefType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcLine\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstLine\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"EnablePortType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TypeBaseRef\" type=\"TypeBaseRefType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"StatesWhenEnabling\" type=\"xsd:string\" default=\"held\"/>\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcLine\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstLine\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TriggerPortType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TypeBaseRef\" type=\"TypeBaseRefType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"TriggerType\" type=\"xsd:string\" default=\"rising\"/>\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcLine\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstLine\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"InputPortType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TypeBaseRef\" type=\"TypeBaseRefType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Number\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcFaultToInput\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstFaultToInput\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcIOPortAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcConnector\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcLine\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstLine\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ActionPortType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TypeBaseRef\" type=\"TypeBaseRefType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcLine\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstLine\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"StateType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Choice\" type=\"ChoiceType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Conditional\" type=\"ConditionalType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ConnectorRef\" type=\"ConnectorRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Data\" type=\"DataType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"DeepHistory\" type=\"DeepHistoryType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Entry\" type=\"EntryType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Event\" type=\"EventType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Exit\" type=\"ExitType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Fork\" type=\"ForkType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"History\" type=\"HistoryType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Join\" type=\"JoinType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Junction\" type=\"JunctionType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ShallowHistory\" type=\"ShallowHistoryType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"State\" type=\"StateType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Terminate\" type=\"TerminateType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"TransStart\" type=\"TransStartType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Transition\" type=\"TransitionType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Decomposition\" type=\"xsd:string\" default=\"OR_STATE\"/>\n";
		str +="		<xsd:attribute name=\"Name\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"EnterAction\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"DuringAction\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ExitAction\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Order\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Description\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Methods\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyConnectorRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TransitionType\">\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Trigger\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Guard\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Action\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ConditionAction\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Order\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"HistoryType\">\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyConnectorRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TransStartType\">\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyConnectorRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"JunctionType\">\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyConnectorRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ConnectorRefType\">\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyConnectorRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"StateflowType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"State\" type=\"StateType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"DataType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TypeBaseRef\" type=\"TypeBaseRefType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Description\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Name\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"DataType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Port\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Units\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"InitialValue\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Min\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Max\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ArraySize\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ArrayFirstIndex\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Scope\" type=\"xsd:string\" default=\"LOCAL_DATA\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"EventType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"TypeBaseRef\" type=\"TypeBaseRefType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Description\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Name\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Scope\" type=\"xsd:string\" default=\"LOCAL_EVENT\"/>\n";
		str +="		<xsd:attribute name=\"Trigger\" type=\"xsd:string\" default=\"EITHER_EDGE_EVENT\"/>\n";
		str +="		<xsd:attribute name=\"Port\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ConditionalType\">\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyConnectorRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ShallowHistoryType\">\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyConnectorRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"DeepHistoryType\">\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyConnectorRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"JoinType\">\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyConnectorRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ForkType\">\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyConnectorRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ChoiceType\">\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyConnectorRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"EntryType\">\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyConnectorRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ExitType\">\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyConnectorRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TerminateType\">\n";
		str +="		<xsd:attribute name=\"RefId\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyConnectorRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstTransition\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"OSType\">\n";
		str +="		<xsd:attribute name=\"ContextSwitchTime\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"SendOverheadTime\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"RecvOverheadTime\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"TickResolution\" type=\"xsd:string\" default=\"1ms\"/>\n";
		str +="		<xsd:attribute name=\"MaxTaskNumber\" type=\"xsd:long\" default=\"1048576\"/>\n";
		str +="		<xsd:attribute name=\"SchedulingAlgorithm\" type=\"xsd:string\" default=\"Static\"/>\n";
		str +="		<xsd:attribute name=\"ISROverheadTime\" type=\"xsd:string\" default=\"0s\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"WireType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcWire_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstWire_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"HardwareUnitType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"AcquisitionConnection\" type=\"AcquisitionConnectionType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ActuationConnection\" type=\"ActuationConnectionType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"BChan\" type=\"BChanType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"CANBus\" type=\"CANBusType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"HardwareUnit\" type=\"HardwareUnitType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"IChan\" type=\"IChanType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"IODevice\" type=\"IODeviceType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Network\" type=\"NetworkType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Node\" type=\"NodeType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"OChan\" type=\"OChanType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"OldBus\" type=\"OldBusType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PhysConnection\" type=\"PhysConnectionType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Plant\" type=\"PlantType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"SerialLink\" type=\"SerialLinkType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"TTBus\" type=\"TTBusType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"TTExecContext\" type=\"TTExecContextType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Wire\" type=\"WireType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Configuration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PlatformLibraryType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"HardwareUnit\" type=\"HardwareUnitType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"NetworkType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"BChan\" type=\"BChanType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"TTExecContext\" type=\"TTExecContextType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"DataRate\" type=\"xsd:string\" default=\"1b\"/>\n";
		str +="		<xsd:attribute name=\"Configuration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"IChanType\">\n";
		str +="		<xsd:attribute name=\"Configuration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ChanNum\" type=\"xsd:long\" default=\"-1\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcCommMapping\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstCommMapping\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcExecutionAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcWire\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstWire\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcAcquisitionConnection\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"OChanType\">\n";
		str +="		<xsd:attribute name=\"Configuration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ChanNum\" type=\"xsd:long\" default=\"-1\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcCommMapping\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstCommMapping\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcExecutionAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcWire\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstWire\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstActuationConnection\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"BChanType\">\n";
		str +="		<xsd:attribute name=\"Configuration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ChanNum\" type=\"xsd:long\" default=\"-1\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcCommMapping\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstCommMapping\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcExecutionAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcWire\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstWire\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PlantType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcPhysConnection\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstPhysConnection\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"IODeviceType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"BChan\" type=\"BChanType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"IChan\" type=\"IChanType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"OChan\" type=\"OChanType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"TTExecContext\" type=\"TTExecContextType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Configuration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"DeviceType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcActuationConnection\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstAcquisitionConnection\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcPhysConnection\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstPhysConnection\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PhysConnectionType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcPhysConnection_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstPhysConnection_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AcquisitionConnectionType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcAcquisitionConnection_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstAcquisitionConnection_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ActuationConnectionType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcActuationConnection_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstActuationConnection_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"NodeType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"BChan\" type=\"BChanType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"IChan\" type=\"IChanType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"OChan\" type=\"OChanType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"OS\" type=\"OSType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"TTExecContext\" type=\"TTExecContextType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Configuration\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Simulator\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ROM\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RAM\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Speed\" type=\"xsd:long\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"CPU\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"PlatformType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"BusIDList\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyNodeRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"DeploymentLibraryType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"System\" type=\"SystemType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"SystemType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"AsyncPeriodicExecInfo\" type=\"AsyncPeriodicExecInfoType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"CommMapping\" type=\"CommMappingType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ComponentAssignment\" type=\"ComponentAssignmentType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ComponentRef\" type=\"ComponentRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Dependency\" type=\"DependencyType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"ExecutionAssignment\" type=\"ExecutionAssignmentType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"NodeRef\" type=\"NodeRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PlantComponentRef\" type=\"PlantComponentRefType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"SporadicExecInfo\" type=\"SporadicExecInfoType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"TTExecInfo\" type=\"TTExecInfoType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"referedbyDesignReference\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"NodeRefType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcCommMapping__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstCommMapping__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstExecutionAssignment__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"srcComponentAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ComponentRefType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcCommMapping__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstCommMapping__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"referedbyTaskInst\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"referedbyAction\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"referedbyFaultMgrTask\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcExecutionAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstExecutionAssignment__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcDependency__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstDependency__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstComponentAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"referedbyComponentRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"CommMappingType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcCommMapping__rp_helper\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstCommMapping__rp_helper\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"srcCommMapping_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstCommMapping_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"DependencyType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcDependency__rp_helper\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstDependency__rp_helper\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"srcDependency_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstDependency_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ComponentAssignmentType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcComponentAssignment_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"dstComponentAssignment_end_\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PlantComponentRefType\">\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"position\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"srcCommMapping__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstCommMapping__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"referedbyTaskInst\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"referedbyAction\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"referedbyFaultMgrTask\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcExecutionAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstExecutionAssignment__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"srcDependency__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstDependency__rp_helper_rev\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"dstComponentAssignment\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"referedbyComponentRef\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"ref\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"RootFolderType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"ArchitectureLibrary\" type=\"ArchitectureLibraryType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"DeploymentLibrary\" type=\"DeploymentLibraryType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"DesignFolder\" type=\"DesignFolderType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PlatformLibrary\" type=\"PlatformLibraryType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"RequirementsLibrary\" type=\"RequirementsLibraryType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"RootFolder\" type=\"RootFolderType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Types\" type=\"TypesType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"name\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_libname\" type=\"xsd:string\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +=" <xsd:element name=\"FaultEvent\" type=\"FaultEventType\"/>\n";
		str +=" <xsd:element name=\"Interval\" type=\"IntervalType\"/>\n";
		str +=" <xsd:element name=\"IOPortInfo\" type=\"IOPortInfoType\"/>\n";
		str +=" <xsd:element name=\"IOPortInfoRef\" type=\"IOPortInfoRefType\"/>\n";
		str +=" <xsd:element name=\"IOPortAssignment\" type=\"IOPortAssignmentType\"/>\n";
		str +=" <xsd:element name=\"OldTask\" type=\"OldTaskType\"/>\n";
		str +=" <xsd:element name=\"RootFolder\" type=\"RootFolderType\"/>\n";
		str +="\n";
		str +="</xsd:schema>\n";
		str +="\n";
	}
		return str;
}
} //namespace
#endif
