/* GenESM2SFC_main.cpp generated on Mon Jul 23 16:51:08 2012
 */

#include "GenESM2SFC.h"
#include "InputFileRegistry.h"
#include "UdmDom.h"
#include "UdmGme.h"
#include "RTTGenerator.h"
#include "GReATUtils.h"
#include <direct.h>

// Extern global temporary root object(s).
void usage()
{
	std::cout << "Usage:  TL.exe ESMoL=\"..\\..\\aero_dap3dof.mga\"!\"Udm\\\"  SFC=\"..\\..\\aero_dap3dof_sfc.xml\"!\"Udm\\SFC.xsd\"  or\n\tTL -d\n\n";
}

int main( int argc, char* argv[])
{
	InputFileRegistry ifr;
	ifr.registerFile( "ESMoL=\"..\\..\\aero_dap3dof.mga\"!\"Udm\\\" ");
	ifr.registerFile( "SFC=\"..\\..\\aero_dap3dof_sfc.xml\"!\"Udm\\SFC.xsd\" ");
	if( argc== 1)
	{
		usage( );
		return -1;
	}
	else
		if( ( argc== 2)&& ( std::string( argv[ 1])== "-d"))
			std::cout << "Executing with default arguments." << std::endl;
		else
			for( int i= 1; i<argc; ++i)
			{
				if( false== ifr.registerFile( argv[ i]))
					throw InputFileEx( std::string( "Invalid input file expression: ") + argv[ i]);
			}
	try
	{
		// Initialize RTT
		char cwd[_MAX_PATH];
		_getcwd(cwd, _MAX_PATH);
		UdmUtil::copy_assoc_map udm_copyMap;
		map<int, int> rtt_copyIdMap;
		std::string rttname("RTT");
		rttname.append("_");
		rttname.append(dropExtension(dropPath(ifr.getFileName( "ESMoL"))));
		rttname.append("_");
		rttname.append(dropExtension(dropPath(ifr.getFileName( "SFC"))));
		RTTGenerator::Instance(getFullPath((std::string)cwd,rttname).append(".mga"), rttname);
		// 
		std::vector< Udm::StaticDataNetworkSpecifier> dnsvec;
		// Open ESMoL r
		Udm::SmartDataNetwork sdnESMoL_2f65( ESMoL::diagram);
		sdnESMoL_2f65.OpenExisting( ifr.getFileName( "ESMoL"), UseXSD()( ifr.getFileName( "ESMoL")) ? ifr.getXsdName( "ESMoL") : "ESMoL", Udm::CHANGES_LOST_DEFAULT);
		RTTGenerator::Instance()->generateDataNetwork(sdnESMoL_2f65.testdn()->uniqueId(), getFullPath((std::string)cwd,ifr.getFileName( "ESMoL")), dropPath(ifr.getFileName( "ESMoL")));
		Udm::StaticDataNetworkSpecifier sdns_ESMoL_2f66( ifr.getFileName( "ESMoL"), &sdnESMoL_2f65);
		dnsvec.push_back( sdns_ESMoL_2f66);
		// Open SFC w
		Udm::SmartDataNetwork sdnSFC_2f68( SFC::diagram);
		sdnSFC_2f68.CreateNew( ifr.getFileName( "SFC"), UseXSD()( ifr.getFileName( "SFC")) ? ifr.getXsdName( "SFC") : "SFC", SFC::Project::meta, Udm::CHANGES_LOST_DEFAULT);
		RTTGenerator::Instance()->generateDataNetwork(sdnSFC_2f68.testdn()->uniqueId(), getFullPath((std::string)cwd,ifr.getFileName( "SFC")), dropPath(ifr.getFileName( "SFC")));
		Udm::StaticDataNetworkSpecifier sdns_SFC_2f69( ifr.getFileName( "SFC"), &sdnSFC_2f68);
		dnsvec.push_back( sdns_SFC_2f69);
		// Create the project
		Udm::StaticUdmProject prj( dnsvec, ESM2SFC::diagram);
		Udm::DataNetwork& eSMoL_ref_2f67= prj.GetDataNetwork( ifr.getFileName( "ESMoL"));
		Udm::DataNetwork& sFC_ref_2f6a= prj.GetDataNetwork( ifr.getFileName( "SFC"));
		Packets_t rootStates_c1f;
		Packets_t projects_c21;
		// get objects from DNs
		ESMoL::RootFolder rootESMoL_2f6b= ESMoL::RootFolder::Cast( eSMoL_ref_2f67.GetRootObject());
		std::set< ESMoL::Stateflow> stateflows_2f6c= rootESMoL_2f6b.Stateflow_kind_children();
		for( std::set< ESMoL::Stateflow>::const_iterator itstateflows_2f6c= stateflows_2f6c.begin(); itstateflows_2f6c!= stateflows_2f6c.end(); ++itstateflows_2f6c)
		{
			const ESMoL::Stateflow& currStateflow_2f6d= *itstateflows_2f6c;
			SFC::Project rootSFC_2f6e= SFC::Project::Cast( sFC_ref_2f6a.GetRootObject());
			// Add objects to input packets.
			projects_c21.push_back( rootSFC_2f6e);
			rootStates_c1f.push_back( currStateflow_2f6d);
		}
		// Get access to temporary root object(s).
		// transformation
		TL_c1e tL_c1e;
		tL_c1e( rootStates_c1f, projects_c21);
		// Close the project
		prj.Close();
		sdnESMoL_2f65.CloseNoUpdate();
		sdnSFC_2f68.CloseWithUpdate();
		// close RTT model
		RTTGenerator::Instance()->close();
	}
	catch( udm_exception &e)
	{
		cout << e.what() << endl;
	}
	return 0;
}

