﻿// -----------------------------------------------------------------------
// <copyright file="Jenkins.cs" company="">
// TODO: Update copyright text.
// </copyright>
// -----------------------------------------------------------------------

namespace JobManager.Jenkins
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Net;
    using System.IO;
    using System.Web;
    using System.Runtime.InteropServices;

    /// <summary>
    /// TODO: Update summary.
    /// </summary>
    public class Jenkins
    {
        private string SendPostRequest(
            string url,
            string content = "",
            string headers = null)
        {
            string responseFromServer = null;

            try
            {
                // Create a request using a URL that can receive a post. 
                WebRequest request = WebRequest.Create(url);
                // Set the Method property of the request to POST.
                request.Method = "POST";
                // Create POST data and convert it to a byte array.
                string postData = content;
                byte[] byteArray = Encoding.UTF8.GetBytes(postData);
                // Set the ContentType property of the WebRequest.
                request.ContentType = headers;
                // Set the ContentLength property of the WebRequest.
                request.ContentLength = byteArray.Length;
                // Get the request stream.
                using (Stream dataStream = request.GetRequestStream())
                {
                    // Write the data to the request stream.
                    dataStream.Write(byteArray, 0, byteArray.Length);
                }

                // Get the response.
                using (WebResponse response = request.GetResponse())
                {
                    // Display the status.
                    Console.WriteLine(((HttpWebResponse)response).StatusDescription);

                    // Get the stream containing content returned by the server.
                    using (Stream dataStream = response.GetResponseStream())
                    {
                        // Open the stream using a StreamReader for easy access.
                        using (StreamReader reader = new StreamReader(dataStream))
                        {
                            // Read the content.
                            responseFromServer = reader.ReadToEnd();
                            // Display the content.
                            Console.WriteLine(responseFromServer);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine(ex.ToString());
            }

            return responseFromServer;
        }

        private string SendGetRequest(string url)
        {
            string responseFromServer = null;

            try
            {
                // Create a request using a URL that can receive a post. 
                WebRequest request = WebRequest.Create(url);
                // Set the Method property of the request to POST.
                request.Method = "GET";

                // Get the response.
                using (WebResponse response = request.GetResponse())
                {
                    // Display the status.
                    Console.WriteLine(((HttpWebResponse)response).StatusDescription);

                    // Get the stream containing content returned by the server.
                    using (Stream dataStream = response.GetResponseStream())
                    {
                        // Open the stream using a StreamReader for easy access.
                        using (StreamReader reader = new StreamReader(dataStream))
                        {
                            // Read the content.
                            responseFromServer = reader.ReadToEnd();
                            // Display the content.
                            Console.WriteLine(responseFromServer);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine(ex.ToString());
            }

            return responseFromServer;
        }


        public struct Queries
        {
            public const string INFO = "api/json";
            public const string JOB_INFO = "job/{0}/api/json?depth=0";
            public const string Q_INFO = "queue/api/json?depth=0";
            public const string CREATE_JOB = "createItem?name={0}"; //also post config.xml
            public const string CONFIG_JOB = "job/{0}/config.xml";
            public const string DELETE_JOB = "job/{0}/doDelete";
            public const string ENABLE_JOB = "job/{0}/enable";
            public const string DISABLE_JOB = "job/{0}/disable";
            public const string COPY_JOB = "createItem?name={0}&mode=copy&from={1}";
            public const string BUILD_JOB = "job/{0}/build";
            //public const string BUILD_WITH_PARAMS_JOB = "job/{0}/buildWithParameters";
            public const string BUILD_WITH_PARAMS_JOB = "job/{0}/build?delay=0sec";
            

            public const string CREATE_NODE = "computer/doCreateItem?{0}";
            public const string DELETE_NODE = "computer/{0}/doDelete";
            public const string NODE_INFO = "computer/{0}/api/json?depth=0";
            public const string NODE_TYPE = "hudson.slaves.DumbSlave$DescriptorImpl";
        }

        public Job.Job GetJobInfo(string name)
        {
            string response = SendGetRequest(ServerUrl + String.Format(Queries.JOB_INFO, name));
            Console.WriteLine(response);
            Job.Job jobInfo = null;
            if (response != null)
            {
                try
                {
                    jobInfo = Newtonsoft.Json.JsonConvert.DeserializeObject<Job.Job>(response);
                }
                catch (Newtonsoft.Json.JsonSerializationException ex)
                {
                    System.Diagnostics.Debug.WriteLine(ex.ToString());
                }
            }
            return jobInfo;
        }

        //public object Open(string url)
        //{
        //    // for authentication...
        //    throw new NotImplementedException();
        //}


        public object GetQueueInfo()
        {
            string response = SendGetRequest(ServerUrl + Queries.Q_INFO);
            Console.WriteLine(response);
            return response;
        }

        public Info.Info GetInfo()
        {
            string response = SendGetRequest(ServerUrl + Queries.INFO);
            Console.WriteLine(response);
            Info.Info info = null;
            if (response != null)
            {
                try
                {
                    info = Newtonsoft.Json.JsonConvert.DeserializeObject<Info.Info>(response);
                }
                catch (Newtonsoft.Json.JsonSerializationException ex)
                {
                    System.Diagnostics.Debug.WriteLine(ex.ToString());
                }
            }
            return info;
        }

        public List<Info.Job> GetJobs()
        {
            var info = GetInfo();
            if (info != null)
            {
                return info.jobs;
            }
            else
            {
                return new List<Info.Job>();
            }
        }


        public object CopyJob(
            string from_name,
            string to_name)
        {
            throw new NotImplementedException();
        }

        public bool DeleteJob(string name)
        {
            var jobinfo = GetJobInfo(name);
            if (jobinfo != null)
            {
                string response = SendPostRequest(ServerUrl + String.Format(Queries.DELETE_JOB, name));
                Console.WriteLine(response);
                return !JobExists(name);
            }
            else
            {
                return true;
            }
        }

        public void EnableJob(string name)
        {
            var jobinfo = GetJobInfo(name);
            if (jobinfo != null)
            {
                string response = SendPostRequest(ServerUrl + String.Format(Queries.ENABLE_JOB, name));
                Console.WriteLine(response);
            }
        }

        public void DisableJob(string name)
        {
            var jobinfo = GetJobInfo(name);
            if (jobinfo != null)
            {
                string response = SendPostRequest(ServerUrl + String.Format(Queries.DISABLE_JOB, name));
                Console.WriteLine(response);
            }
        }

        public bool JobExists(string name)
        {
            var info = GetJobInfo(name);
            return info == null ? false : true;
        }

        public Job.Job CreateJob(
            string name,
            string config_xml)
        {
            var jobinfo = GetJobInfo(name);
            if (jobinfo == null)
            {
                string response = SendPostRequest(
                    ServerUrl + String.Format(Queries.CREATE_JOB, name),
                    config_xml,
                    "text/xml");
                Console.WriteLine(response);
                jobinfo = GetJobInfo(name);
            }
            return jobinfo;
        }

        public object GetJobConfig(string name)
        {
            throw new NotImplementedException();
        }

        public void BuildJobUrl(
            string name,
            Dictionary<string, string> parameters = null,
            string token = null)
        {
            if (parameters != null)
            {
                if (token != null)
                {
                    parameters.Add("token", token);
                }
                string additionalParameters = HttpUtility.UrlEncode(Newtonsoft.Json.JsonConvert.SerializeObject(parameters));
                string response = SendPostRequest(
                    ServerUrl + String.Format(Queries.BUILD_WITH_PARAMS_JOB, name) + "?" + additionalParameters);
                Console.WriteLine(response);
            }
            else if (token != null)
            {
                string response = SendPostRequest(ServerUrl + String.Format(Queries.BUILD_JOB, name) + "?" + HttpUtility.UrlEncode(token));
                Console.WriteLine(response);
            }
            else
            {
                string response = SendPostRequest(ServerUrl + String.Format(Queries.BUILD_JOB, name));
                Console.WriteLine(response);
            }
            
        }

        public void BuildJob(
            string name,
            Dictionary<string, string> parameters = null,
            string token = null)
        {
            if (JobExists(name))
            {
                BuildJobUrl(name, parameters, token);
            }
        }
        public void BuildJob(
            string name,
            string file,
            Dictionary<string, string> parameters = null,
            string token = null)
        {
            if (file == null)
            {
                BuildJob(name, parameters, token);
            }
            else
            {
                UploadFilesToRemoteUrl(
                    ServerUrl + String.Format(Queries.BUILD_WITH_PARAMS_JOB, name) + "?" + HttpUtility.UrlEncode(token),
                    new string[] { file },
                    "log.txt",
                    new System.Collections.Specialized.NameValueCollection() {
                        {"name", "data.zip"},
                        //{"file0", Path.GetFileName(file)},
                        {"json", "{\"parameter\": {\"name\": \"data.zip\", \"file\": \"file0\"}}"},
                        {"Submit", "Build"}
                    });
            }
        }

        // TODO: implement node functions

        // TODO: implement view functions
        // https://issues.jenkins-ci.org/browse/JENKINS-8927?page=com.atlassian.jira.plugin.system.issuetabpanels:all-tabpanel
        // wget --post-data='name=ViewX&mode=hudson.model.ListView&json={"name": "ViewX", "mode": "hudson.model.ListView"}' http://.../jenkins/createView


        public string ServerUrl { get; set; }

        public Jenkins(
            string url,
            string username = null,
            string password = null)
        {
            ServerUrl = url;
        }

        // http://stackoverflow.com/questions/566462/upload-files-with-httpwebrequest-multipart-form-data
        public static void UploadFilesToRemoteUrl(
            string url,
            string[] files,
            string logpath,
            System.Collections.Specialized.NameValueCollection nvc)
        {
            long length = 0;
            string boundary = "----------------------------" +
            DateTime.Now.Ticks.ToString("x");


            HttpWebRequest httpWebRequest2 = (HttpWebRequest)WebRequest.Create(url.TrimEnd('?'));
            httpWebRequest2.ContentType = "multipart/form-data; boundary=" +
            boundary;
            httpWebRequest2.Method = "POST";
            httpWebRequest2.KeepAlive = true;
            httpWebRequest2.Credentials =
            System.Net.CredentialCache.DefaultCredentials;

            Stream memStream = new System.IO.MemoryStream();

            byte[] boundarybytes = System.Text.Encoding.ASCII.GetBytes("\r\n--" +
            boundary + "\r\n");

            byte[] lastboundarybytes = System.Text.Encoding.ASCII.GetBytes("\r\n--" +
boundary + "--\r\n");

            string formdataTemplate = "\r\n--" + boundary +
            "\r\nContent-Disposition: form-data; name=\"{0}\"\r\n\r\n{1}";

            foreach (string key in nvc.Keys.OfType<string>().Where(x => x == "name"))
            {
                string formitem = string.Format(formdataTemplate, key, nvc[key]);
                byte[] formitembytes = System.Text.Encoding.UTF8.GetBytes(formitem);
                memStream.Write(formitembytes, 0, formitembytes.Length);
            }

            memStream.Write(boundarybytes, 0, boundarybytes.Length);

            string headerTemplate = "Content-Disposition: form-data; name=\"{0}\"; filename=\"{1}\"\r\n";

            for (int i = 0; i < files.Length; i++)
            {

                //string header = string.Format(headerTemplate, "file" + i, files[i]);
                string header = string.Format(headerTemplate, "file0", Path.GetFileName(files[i]));
                byte[] headerbytes = System.Text.Encoding.UTF8.GetBytes(header);
                memStream.Write(headerbytes, 0, headerbytes.Length);

                header = string.Format("Content-Type: {0}\r\n\r\n", getMimeFromFile(files[i]));
                headerbytes = System.Text.Encoding.UTF8.GetBytes(header);
                memStream.Write(headerbytes, 0, headerbytes.Length);

                FileStream fileStream = new FileStream(files[i], FileMode.Open,
                FileAccess.Read);
                byte[] buffer = new byte[1024];

                int bytesRead = 0;

                while ((bytesRead = fileStream.Read(buffer, 0, buffer.Length)) != 0)
                {
                    memStream.Write(buffer, 0, bytesRead);

                }

                if (i < files.Length - 1)
                {
                    memStream.Write(boundarybytes, 0, boundarybytes.Length);
                }
                fileStream.Close();
            }

            foreach (string key in nvc.Keys.OfType<string>().Where(x => x != "name"))
            {
                string formitem = string.Format(formdataTemplate, key, nvc[key]);
                byte[] formitembytes = System.Text.Encoding.UTF8.GetBytes(formitem);
                memStream.Write(formitembytes, 0, formitembytes.Length);
            }

            memStream.Write(lastboundarybytes, 0, lastboundarybytes.Length);

            httpWebRequest2.ContentLength = memStream.Length;

            Stream requestStream = httpWebRequest2.GetRequestStream();

            memStream.Position = 0;
            byte[] tempBuffer = new byte[memStream.Length];
            memStream.Read(tempBuffer, 0, tempBuffer.Length);
            memStream.Close();
            requestStream.Write(tempBuffer, 0, tempBuffer.Length);
            requestStream.Close();


            WebResponse webResponse2 = httpWebRequest2.GetResponse();

            Stream stream2 = webResponse2.GetResponseStream();
            StreamReader reader2 = new StreamReader(stream2);


            Console.WriteLine(reader2.ReadToEnd());

            webResponse2.Close();
            httpWebRequest2 = null;
            webResponse2 = null;
        }

        // http://stackoverflow.com/questions/58510/using-net-how-can-you-find-the-mime-type-of-a-file-based-on-the-file-signature
        [DllImport(@"urlmon.dll", CharSet = CharSet.Auto)]
        private extern static System.UInt32 FindMimeFromData(
            System.UInt32 pBC,
            [MarshalAs(UnmanagedType.LPStr)] System.String pwzUrl,
            [MarshalAs(UnmanagedType.LPArray)] byte[] pBuffer,
            System.UInt32 cbSize,
            [MarshalAs(UnmanagedType.LPStr)] System.String pwzMimeProposed,
            System.UInt32 dwMimeFlags,
            out System.UInt32 ppwzMimeOut,
            System.UInt32 dwReserverd
        );

        public static string getMimeFromFile(string filename)
        {
            if (!File.Exists(filename))
                throw new FileNotFoundException(filename + " not found");

            byte[] buffer = new byte[256];
            using (FileStream fs = new FileStream(filename, FileMode.Open))
            {
                if (fs.Length >= 256)
                    fs.Read(buffer, 0, 256);
                else
                    fs.Read(buffer, 0, (int)fs.Length);
            }
            try
            {
                System.UInt32 mimetype;
                FindMimeFromData(0, null, buffer, 256, null, 0, out mimetype, 0);
                System.IntPtr mimeTypePtr = new IntPtr(mimetype);
                string mime = Marshal.PtrToStringUni(mimeTypePtr);
                Marshal.FreeCoTaskMem(mimeTypePtr);
                return mime;
            }
            catch (Exception e)
            {
                return "unknown/unknown";
            }
        }

    }
}
